<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Hadir</title>
</head>

<body>
    <style>
        .detail,
        tr,
        td {
            border: 0 !important;
            border-spacing: 0 !important;
        }

        .daftarHadir {
            width: 100%;
            max-width: 1300px;
            border-collapse: collapse;
            font-size: 12px;
        }

        .borderline {
            border: 1px solid black !important;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        h2 {
            text-align: center;
            margin-bottom: 10px;
        }

        h3 {
            text-align: center;
            margin-bottom: 10px;
        }

        p {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .nomer {
            width: 2%;
            text-align: center;
        }

        .name {
            width: 38%;
        }

        .departemen {
            width: 30%;
        }

        .ttd {
            width: 30%;
        }
    </style>
    <h2>DAFTAR HADIR RAPAT</h2>
    <h3>PT. JASA PRIMA LOGISTIK BULOG</h3>
    <table class="detail">
        <tr>
            <td>Hari/Tanggal</td>
            <td>:</td>
            <td>{{ \Carbon\Carbon::parse($agendaRapat->tanggal)->locale('id')->translatedFormat('l / d F Y') }}</td>
        </tr>
        <tr>
            <td>Pukul</td>
            <td>:</td>
            <td>{{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->mulai)->format('h:i A') }} s.d. {{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->selesai)->format('h:i A') }}</td>
        </tr>
        <tr>
            <td>Tempat</td>
            <td>:</td>
            <td>{{ $agendaRapat->ruangan->name }}</td>
        </tr>
        <tr>
            <td>Agenda Rapat</td>
            <td>:</td>
            <td>{{ $agendaRapat->judul }}</td>
        </tr>
    </table>
    <br>
    <br>
    <table class="daftarHadir">
        <thead>
            <tr>
                <th class="borderline">No.</th>
                <th class="borderline">Nama</th>
                <th class="borderline">Jabatan</th>
                <th class="borderline">Tanda Tangan</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($pesertaRapat as $index => $peserta)
            <tr>
                <td class="nomer borderline">{{ $index + 1 }}</td>
                <td class="name borderline">{{ $peserta->user->name }}</td>
                <td class="departemen borderline"> {{$peserta->user->departemen->name}}</td>
                <td class="ttd borderline"></td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>