<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan</title>
</head>

<body>
    <style>
        table {
            width: 100%;
            max-width: 1300px;
            border-collapse: collapse;
            font-size: 12px;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        h2 {
            text-align: center;
            margin-bottom: 10px;
        }

        p {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .nomer {
            width: 2%;
            text-align: center;
        }

        .tanggal {
            width: 7%;
        }

        .agenda {
            width: 20%;
        }

        .ruangan {
            width: 15%;
        }

        .pukul {
            width: 3%;
        }

        .peserta {
            width: 20%;
        }

        .keterangan {
            width: 20%;
        }

        .metode {
            width: 10%;
        }
    </style>

    <h2>JADWAL RAPAT PT. JASA PRIMA LOGISTIK BULOG</h2>
    <p>Dari Tanggal: {{ \Carbon\Carbon::parse($agendaRapats->first()->tanggal)->locale('id')->translatedFormat('l, d F Y') }} Sampai Tanggal: {{ \Carbon\Carbon::parse($agendaRapats->last()->tanggal)->locale('id')->translatedFormat('l, d F Y') }}</p>
    <table>
        <thead>
            <tr>
                <th>No.</th>
                <th>Tanggal</th>
                <th>Agenda</th>
                <th>Waktu</th>
                <th>Tempat</th>
                <th>Peserta Rapat</th>
                <th>Keterangan</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($agendaRapats as $index => $agendaRapat)
            <tr>
                <td class="nomer">{{ $index + 1 }}</td>
                <td class="tanggal">{{ \Carbon\Carbon::parse($agendaRapat->tanggal)->locale('id')->translatedFormat('l, d F Y') }}</td>
                <td class="agenda">{{ $agendaRapat->judul }}</td>
                <td class="pukul">Dari:<br>{{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->mulai)->format('h:i A') }} <br><br>Sampai:<br> {{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->selesai)->format('h:i A') }}</td>
                <td class="ruangan">{{ $agendaRapat->ruangan->name }}</td>
                <td class="peserta">
                    <?php
                    $internalPeserta = 0;
                    $externalPeserta = 0;
                    $listInternal = "";
                    $listExternal = "";
                    foreach ($agendaRapat->pesertaRapat as $peserta) {
                        if ($peserta->user->is_guest == "Internal") {
                            $listInternal .= "<li>" . $peserta->user->name . "</li>";
                        }
                        if ($peserta->user->is_guest == "External") {
                            $listExternal .= "<li>" . $peserta->user->name . "</li>";
                        }
                    }
                    ?>
                    @if($listInternal!="")
                    <strong>Internal:</strong>
                    <ol>
                        {!! $listInternal !!}
                    </ol>
                    @endif

                    @if($listExternal!="")
                    <strong>External:</strong>
                    <ol>
                        {!! $listExternal !!}
                    </ol>
                    @endif
                </td>
                <td class="keterangan">{{ $agendaRapat->keterangan }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>